/****************************************************************************
* Donohue and Wolfers (2006) 
* Table 5
* Estimating the Impact of Executions on Murder Rates, 
* Testing the Sensitivity of Dezhbakhsh and Shepherd's Results: 1960-2000
****************************************************************************/


clear
set mat 800
set mem 250m
set more off
cd  "..."

use "StatePanel", clear

xi: reg pc_mur execs rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.decade if sample_ds==1 [w=popul], cluster(st)
display (--.1452*(229300000/100000)/38)-1
display (-(-.145-1.96*(.1452/10.58))*(229300000/100000)/38)-1
display (-(-.145+1.96*(.1452/10.58))*(229300000/100000)/38)-1
xi: reg pc_mur execs rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year if sample_ds==1 [w=popul], cluster(st)
lincom (-_b[execs]*(229300000/100000)/38)-1
lincom (-(_b[execs]-1.96*_se[execs])*(229300000/100000)/38)-1
lincom (-(_b[execs]+1.96*_se[execs])*(229300000/100000)/38)-1
xi: reg pc_mur execs rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year if sample_ds==1 & st~="TX" [w=popul], cluster(st)
lincom (-_b[execs]*(229300000/100000)/38)-1
lincom (-(_b[execs]-1.96*_se[execs])*(229300000/100000)/38)-1
lincom (-(_b[execs]+1.96*_se[execs])*(229300000/100000)/38)-1
gen exec_pop=100000*execs/(popul*1000)
xi: reg pc_mur exec_pop rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year if sample_ds==1 [w=popul], cluster(st)
lincom -(_b[exec_pop]*(100000/((229300000/38)))*(229300000/100000)/38)-1
lincom -((_b[exec_pop]-1.96*_se[exec_pop])*(100000/((229300000/38)))*(229300000/100000)/38)-1
lincom -((_b[exec_pop]+1.96*_se[exec_pop])*(100000/((229300000/38)))*(229300000/100000)/38)-1
ipolate prisoner year, by(st) g(iprisoner)
gen exec_pris=execs/(iprisoner/1000)
replace exec_pris=0 if execs==0
xi: reg pc_mur exec_pris rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year if sample_ds==1 [w=popul], cluster(st)
lincom -((_b[exec_pris]/(943.6/38))*((229300000/100000)/38))-1
lincom -(((_b[exec_pris]-1.96*_se[exec_pris])/(943.6/38))*((229300000/100000)/38))-1
lincom -(((_b[exec_pris]+1.96*_se[exec_pris])/(943.6/38))*((229300000/100000)/38))-1
sort stid year
gen exec_murd1=execs/(l.murders)
replace exec_murd1=0 if execs==0
xi: reg pc_mur exec_murd1 rpc_inc ur ipolice nonwhite age15to19 age20to24 i.st i.year if sample_ds==1 [w=popul], cluster(st)
lincom -((_b[exec_murd1]/(19473/38))*((229300000/100000)/38))-1
lincom -(((_b[exec_murd1]-1.96*_se[exec_murd1])/(19473/38))*((229300000/100000)/38))-1
lincom -(((_b[exec_murd1]+1.96*_se[exec_murd1])/(19473/38))*((229300000/100000)/38))-1

